-- @Class RDM_ModBase
-- =====================================================================================
DefineClass.RDM_ModBase = {
	Mod = false,
	ModID = "", -- SET MANUALLY FOREACH MOD
	ModDir = "",
	ModTitle = "",
	ModVersion = "",
	
	-- LockUnlock Rules
	rules_buildings = {},
	rules_upgrades = {},
	rules_modifiers = {},
	rules_crops = {},
	
	-- Mod content IDs
	techs = {},
	buildings = {},
	upgrades = {},
	modifiers = {},
	crops = {},
}
function RDM_ModBase:Init()
	self:SetMod()
	self:SetModDir()
	self:SetModTitle()
	self:SetModVersion()
	
	if RDM_ModRegister then 
		RDM_ModRegister[self.class] = self
	end
	
	if not RDM_ModRegister then
		ModLog("[SILVA][Error] Global var RDM_ModRegister is nil or doesn't exist.")
	end
	
	Msg("RDM_ModLoaded", self.class, self.ModID)
end

-- SET Mod informations
function RDM_ModBase:SetMod() 			self.Mod 		= Mods[self.ModID] end
function RDM_ModBase:SetModDir() 		self.ModDir		= self.Mod.env.CurrentModPath or "" end
function RDM_ModBase:SetModTitle() 		self.ModTitle 	= self.Mod.title or "" end


function RDM_ModBase:SetModVersion()
	-- SPACE RACE
	if LuaRevision <= 240905 then
		self.ModVersion = self.Mod.version
	end
	-- GREEN PLANET
	if LuaRevision > 240905 then
		self.ModVersion = self.Mod.version_major .. "." .. self.Mod.version_minor
	end	
end


function RDM_ModBase:GetBuildingRules() 
	return self.rules_buildings
end